﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.SharePoint.Client;

namespace UpdateListItem
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         Web web = ctx.Web;
         List list = web.Lists.GetByTitle("Bestellungen");

         // Spezielles Listenelement via CAML abfragen
         ListItemCollection allItems = list.GetItems(new CamlQuery()
         {
           ViewXml = @" 
            <View>
             <Query>
              <Where>
               <Eq>
                 <FieldRef Name='Title'/>
                 <Value Type='Text'>7f5da58e-03da-4951-b746-1890e31418d4</Value>
               </Eq>
              </Where>
             </Query>
             <RowLimit>100</RowLimit>
            </View>"
         });

         // Daten laden und Spalten spezifizieren
         ctx.Load(allItems,
            items => items.Include(
               i => i["Title"],
               i => i["Menge"])
               );

         ctx.ExecuteQuery();

         // Überprüfe, ob ein Listenelement zurückgegeben wurde
         if (allItems != null && allItems.Count > 0)
         {
            // Element aktualisieren
            ListItem item = allItems[0];
            item["Menge"] = 5.0;
            item.Update();

            ctx.ExecuteQuery();

            Console.WriteLine("Bestellung wurde erfolgreich aktualisiert: {0} ({1})", 
               item["Title"], item["Menge"]);     
         }
      }
   }
}
